<div class="space-y-8">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <h1 class="text-2xl font-bold text-white">Progress Log</h1>
        <a href="<?= $base ?>/progress/log" class="inline-flex items-center px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white text-sm font-medium transition">Log Workout</a>
    </div>

    <?php if (isset($_GET['logged'])): ?>
    <div class="p-4 rounded-xl bg-brand-500/20 text-brand-300 border border-brand-500/30">Workout logged.</div>
    <?php endif; ?>

    <!-- Stats -->
    <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-5">
            <p class="text-slate-400 text-sm font-medium">Total logged</p>
            <p class="mt-1 text-xl font-bold text-white"><?= (int)($stats['total_workouts'] ?? 0) ?></p>
        </div>
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-5">
            <p class="text-slate-400 text-sm font-medium">Completed</p>
            <p class="mt-1 text-xl font-bold text-brand-400"><?= (int)($stats['completed_workouts'] ?? 0) ?></p>
        </div>
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-5">
            <p class="text-slate-400 text-sm font-medium">Avg. difficulty</p>
            <p class="mt-1 text-xl font-bold text-white"><?= $stats['avg_difficulty'] ? number_format((float)$stats['avg_difficulty'], 1) : '—' ?></p>
        </div>
    </div>

    <!-- Log list -->
    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 overflow-hidden">
        <div class="px-5 py-4 border-b border-slate-700/50">
            <h2 class="font-semibold text-white">Recent logs</h2>
        </div>
        <?php if (empty($logs)): ?>
        <div class="p-8 text-center text-slate-400">No logs yet. <a href="<?= $base ?>/progress/log" class="text-brand-400 hover:underline">Log your first workout</a>.</div>
        <?php else: ?>
        <ul class="divide-y divide-slate-700/50">
            <?php foreach ($logs as $log): ?>
            <li class="px-5 py-4 flex flex-wrap items-center gap-4">
                <span class="font-medium text-white"><?= date('M j, Y', strtotime($log['workout_date'])) ?></span>
                <span class="px-2 py-0.5 rounded text-xs <?= $log['completed'] ? 'bg-brand-500/20 text-brand-400' : 'bg-slate-600/30 text-slate-400' ?>">
                    <?= $log['completed'] ? 'Completed' : 'Not completed' ?>
                </span>
                <?php if ($log['difficulty_rating']): ?>
                <span class="text-slate-400 text-sm">Difficulty: <?= (int)$log['difficulty_rating'] ?>/5</span>
                <?php endif; ?>
                <?php if (!empty($log['notes'])): ?>
                <span class="text-slate-500 text-sm truncate max-w-xs"><?= htmlspecialchars($log['notes']) ?></span>
                <?php endif; ?>
            </li>
            <?php endforeach; ?>
        </ul>
        <?php endif; ?>
    </div>
</div>
