<?php
$profile = $profile ?? null;
$goalsStr = is_array($profile['goals'] ?? null) ? implode(', ', $profile['goals']) : '';
$prefStr = is_array($profile['preferences'] ?? null) ? implode(', ', $profile['preferences']) : '';
?>
<div class="space-y-8">
    <h1 class="text-2xl font-bold text-white">Edit Profile</h1>

    <form method="post" action="<?= $base ?>/profile/update" class="max-w-2xl space-y-6">
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6 space-y-5">
            <div class="grid gap-5 sm:grid-cols-2">
                <div>
                    <label for="age" class="block text-sm font-medium text-slate-300 mb-1">Age</label>
                    <input type="number" id="age" name="age" min="1" max="120" value="<?= $profile['age'] ?? '' ?>"
                           class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500">
                </div>
                <div>
                    <label for="gender" class="block text-sm font-medium text-slate-300 mb-1">Gender</label>
                    <select id="gender" name="gender" class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500">
                        <option value="">—</option>
                        <option value="male" <?= ($profile['gender'] ?? '') === 'male' ? 'selected' : '' ?>>Male</option>
                        <option value="female" <?= ($profile['gender'] ?? '') === 'female' ? 'selected' : '' ?>>Female</option>
                        <option value="other" <?= ($profile['gender'] ?? '') === 'other' ? 'selected' : '' ?>>Other</option>
                    </select>
                </div>
            </div>
            <div>
                <label for="fitness_level" class="block text-sm font-medium text-slate-300 mb-1">Fitness level (1–5)</label>
                <select id="fitness_level" name="fitness_level" class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500">
                    <option value="">—</option>
                    <?php for ($i = 1; $i <= 5; $i++): ?>
                    <option value="<?= $i ?>" <?= (int)($profile['fitness_level'] ?? 0) === $i ? 'selected' : '' ?>><?= $i ?> - <?= $i === 1 ? 'Beginner' : ($i === 5 ? 'Advanced' : 'Intermediate') ?></option>
                    <?php endfor; ?>
                </select>
            </div>
            <div>
                <label for="weekly_time_available" class="block text-sm font-medium text-slate-300 mb-1">Weekly time available (minutes)</label>
                <input type="number" id="weekly_time_available" name="weekly_time_available" min="0" value="<?= $profile['weekly_time_available'] ?? '' ?>"
                       class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500"
                       placeholder="e.g. 180">
            </div>
            <div>
                <label for="health_conditions" class="block text-sm font-medium text-slate-300 mb-1">Health conditions / notes</label>
                <textarea id="health_conditions" name="health_conditions" rows="3" class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500" placeholder="Any injuries or conditions we should consider"><?= htmlspecialchars($profile['health_conditions'] ?? '') ?></textarea>
            </div>
            <div>
                <label for="goals" class="block text-sm font-medium text-slate-300 mb-1">Goals (comma-separated)</label>
                <input type="text" id="goals" name="goals" value="<?= htmlspecialchars($goalsStr) ?>"
                       class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500"
                       placeholder="e.g. Build muscle, Lose weight">
            </div>
            <div>
                <label for="preferences" class="block text-sm font-medium text-slate-300 mb-1">Preferences (comma-separated)</label>
                <input type="text" id="preferences" name="preferences" value="<?= htmlspecialchars($prefStr) ?>"
                       class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500"
                       placeholder="e.g. Home workout, No equipment">
            </div>
        </div>
        <button type="submit" class="px-6 py-3 rounded-xl bg-brand-600 hover:bg-brand-500 text-white font-semibold transition">Save Profile</button>
    </form>
</div>
