<?php
$session = $session ?? null;
$plan = $plan ?? null;
$dayExercises = $dayExercises ?? [];
$setLogs = $setLogs ?? [];
$sessionId = (int)($session['id'] ?? 0);
?>
<div class="space-y-8">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <a href="<?= $base ?>/plans?id=<?= (int)($plan['id'] ?? 0) ?>" class="text-slate-400 hover:text-white text-sm">← Back to plan</a>
            <h1 class="text-2xl font-bold text-white mt-1">Workout · Day <?= (int)($session['day_number'] ?? 0) ?></h1>
            <p class="text-slate-400 text-sm"><?= date('l, M j, Y', strtotime($session['session_date'] ?? 'now')) ?></p>
        </div>
    </div>

    <div class="space-y-6">
        <?php foreach ($dayExercises as $pe): ?>
        <?php
        $logsForThis = array_filter($setLogs, fn($l) => (int)($l['plan_exercise_id'] ?? 0) === (int)$pe['id']);
        $setsCount = (int)($pe['sets'] ?? 3);
        ?>
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6">
            <h3 class="font-semibold text-white"><?= htmlspecialchars($pe['exercise_name'] ?? $pe['name'] ?? '') ?></h3>
            <p class="text-slate-400 text-sm mt-0.5"><?= (int)$pe['sets'] ?> sets × <?= htmlspecialchars($pe['reps']) ?> reps</p>
            <div class="mt-4 space-y-3">
                <?php for ($setNum = 1; $setNum <= $setsCount; $setNum++): ?>
                <?php $log = current(array_filter($logsForThis, fn($l) => (int)($l['set_number'] ?? 0) === $setNum)); ?>
                <form method="post" action="<?= $base ?>/plans/session/set" class="flex flex-wrap items-center gap-3">
                    <input type="hidden" name="session_id" value="<?= $sessionId ?>">
                    <input type="hidden" name="plan_exercise_id" value="<?= (int)$pe['id'] ?>">
                    <input type="hidden" name="set_number" value="<?= $setNum ?>">
                    <span class="text-slate-400 w-16">Set <?= $setNum ?></span>
                    <input type="number" name="reps" placeholder="Reps" min="0" value="<?= $log ? (int)($log['reps_completed'] ?? '') : '' ?>"
                           class="w-20 px-3 py-2 rounded-lg bg-slate-900 border border-slate-600 text-white">
                    <input type="number" name="weight" step="0.5" placeholder="Weight (kg)" min="0" value="<?= $log && isset($log['weight_used']) ? (float)$log['weight_used'] : '' ?>"
                           class="w-24 px-3 py-2 rounded-lg bg-slate-900 border border-slate-600 text-white">
                    <button type="submit" class="px-3 py-2 rounded-lg bg-brand-600 hover:bg-brand-500 text-white text-sm">Log</button>
                </form>
                <?php endfor; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6">
        <h3 class="font-semibold text-white mb-4">Finish workout</h3>
        <form method="post" action="<?= $base ?>/plans/session/complete">
            <input type="hidden" name="session_id" value="<?= $sessionId ?>">
            <div class="space-y-3">
                <label class="block text-slate-400 text-sm">Difficulty (1–5)</label>
                <select name="difficulty_rating" class="w-full max-w-xs px-3 py-2 rounded-lg bg-slate-900 border border-slate-600 text-white">
                    <option value="">—</option>
                    <?php for ($i = 1; $i <= 5; $i++): ?>
                    <option value="<?= $i ?>"><?= $i ?></option>
                    <?php endfor; ?>
                </select>
                <label class="block text-slate-400 text-sm mt-2">Notes</label>
                <textarea name="notes" rows="2" class="w-full px-3 py-2 rounded-lg bg-slate-900 border border-slate-600 text-white" placeholder="How did it feel?"></textarea>
            </div>
            <button type="submit" class="mt-4 px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white font-medium">Complete workout</button>
        </form>
    </div>
</div>
