<?php
$title = $title ?? 'Workout Plan Generator';
$bodyClass = $bodyClass ?? '';
?>
<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title) ?> | Workout Generator</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        brand: { 50: '#f0fdf4', 100: '#dcfce7', 200: '#bbf7d0', 300: '#86efac', 400: '#4ade80', 500: '#22c55e', 600: '#16a34a', 700: '#15803d', 800: '#166534', 900: '#14532d' },
                        slate: { 850: '#172033', 950: '#0f1729' }
                    },
                    fontFamily: { sans: ['Outfit', 'system-ui', 'sans-serif'] }
                }
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        [x-cloak] { display: none !important; }
        .gradient-bg { background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%); }
        .card-hover { transition: transform 0.2s, box-shadow 0.2s; }
        .card-hover:hover { transform: translateY(-2px); box-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.3); }
    </style>
</head>
<body class="font-sans bg-slate-950 text-slate-100 min-h-screen <?= htmlspecialchars($bodyClass) ?>">
    <?php if (!empty($_user_id)): ?>
    <nav class="fixed top-0 left-0 right-0 z-50 bg-slate-900/90 backdrop-blur border-b border-slate-700/50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <a href="<?= $base ?? '' ?>/" class="flex items-center gap-2 text-brand-400 font-semibold text-lg">
                    <span class="w-8 h-8 rounded-lg bg-brand-600 flex items-center justify-center text-white text-sm">W</span>
                    Workout Generator
                </a>
                <div class="hidden md:flex items-center gap-6">
                    <a href="<?= $base ?? '' ?>/" class="text-slate-300 hover:text-white transition">Dashboard</a>
                    <a href="<?= $base ?? '' ?>/reminders" class="text-slate-300 hover:text-white transition">Reminders</a>
                    <a href="<?= $base ?? '' ?>/profile" class="text-slate-300 hover:text-white transition">Profile</a>
                    <a href="<?= $base ?? '' ?>/exercises" class="text-slate-300 hover:text-white transition">Exercises</a>
                    <a href="<?= $base ?? '' ?>/plans" class="text-slate-300 hover:text-white transition">Plans</a>
                    <a href="<?= $base ?? '' ?>/progress" class="text-slate-300 hover:text-white transition">Progress</a>
                    <span class="text-slate-500 text-sm"><?= htmlspecialchars($_user_email ?? '') ?></span>
                    <a href="<?= $base ?? '' ?>/logout" class="text-slate-400 hover:text-red-400 transition text-sm">Logout</a>
                </div>
                <div class="md:hidden" x-data="{ open: false }">
                    <button @click="open = !open" class="p-2 rounded-lg text-slate-400 hover:bg-slate-800">☰</button>
                    <div x-show="open" x-cloak class="absolute top-16 left-0 right-0 bg-slate-900 border-b border-slate-700 py-4 px-4 flex flex-col gap-2">
                        <a href="<?= $base ?? '' ?>/" class="text-slate-300 hover:text-white">Dashboard</a>
                        <a href="<?= $base ?? '' ?>/reminders" class="text-slate-300 hover:text-white">Reminders</a>
                        <a href="<?= $base ?? '' ?>/profile" class="text-slate-300 hover:text-white">Profile</a>
                        <a href="<?= $base ?? '' ?>/exercises" class="text-slate-300 hover:text-white">Exercises</a>
                        <a href="<?= $base ?? '' ?>/plans" class="text-slate-300 hover:text-white">Plans</a>
                        <a href="<?= $base ?? '' ?>/progress" class="text-slate-300 hover:text-white">Progress</a>
                        <a href="<?= $base ?? '' ?>/logout" class="text-red-400">Logout</a>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    <main class="pt-20 pb-12 px-4 sm:px-6 lg:px-8 max-w-7xl mx-auto">
    <?php else: ?>
    <main class="min-h-screen flex flex-col">
    <?php endif; ?>
        <?php if (!empty($flash)): ?>
        <div class="mb-4 p-4 rounded-xl bg-brand-500/20 text-brand-300 border border-brand-500/30">
            <?= htmlspecialchars($flash) ?>
        </div>
        <?php endif; ?>
        <?php if (!empty($_view_path) && is_file($_view_path)) include $_view_path; ?>
    </main>
    <?php if (!empty($_user_id)): ?>
    <footer class="border-t border-slate-800 py-6 text-center text-slate-500 text-sm">
        Workout Plan Generator &copy; <?= date('Y') ?>
    </footer>
    <?php endif; ?>
</body>
</html>
