<?php
$exercise = $exercise ?? null;
$comments = $comments ?? [];
?>
<div class="space-y-8 max-w-3xl">
    <a href="<?= $base ?>/exercises" class="text-slate-400 hover:text-white text-sm">← Back to library</a>
    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6">
        <h1 class="text-2xl font-bold text-white"><?= htmlspecialchars($exercise['name']) ?></h1>
        <span class="inline-block mt-2 px-2 py-0.5 rounded text-xs font-medium
            <?= ($exercise['difficulty'] ?? '') === 'beginner' ? 'bg-brand-500/20 text-brand-400' : (($exercise['difficulty'] ?? '') === 'advanced' ? 'bg-red-500/20 text-red-400' : 'bg-amber-500/20 text-amber-400') ?>">
            <?= htmlspecialchars($exercise['difficulty'] ?? '') ?>
        </span>
        <?php if (!empty($exercise['description'])): ?>
        <p class="mt-4 text-slate-300"><?= nl2br(htmlspecialchars($exercise['description'])) ?></p>
        <?php endif; ?>
        <?php
        $muscles = is_array($exercise['target_muscles'] ?? null) ? $exercise['target_muscles'] : [];
        $equip = is_array($exercise['equipment'] ?? null) ? $exercise['equipment'] : [];
        ?>
        <?php if (!empty($muscles) || !empty($equip)): ?>
        <div class="mt-4 flex flex-wrap gap-2">
            <?php foreach ($muscles as $m): ?>
            <span class="px-2 py-1 rounded bg-slate-700/50 text-slate-300 text-sm"><?= htmlspecialchars($m) ?></span>
            <?php endforeach; ?>
            <?php foreach ($equip as $e): ?>
            <span class="px-2 py-1 rounded bg-slate-600/50 text-slate-400 text-sm"><?= htmlspecialchars($e) ?></span>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>

    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6">
        <h2 class="font-semibold text-white mb-4">Comments</h2>
        <form method="post" action="<?= $base ?>/comments" class="mb-6">
            <input type="hidden" name="target_type" value="exercise">
            <input type="hidden" name="target_id" value="<?= (int)$exercise['id'] ?>">
            <input type="hidden" name="redirect" value="<?= $base ?>/exercises/show?id=<?= (int)$exercise['id'] ?>">
            <textarea name="body" rows="3" required class="w-full px-4 py-2 rounded-xl bg-slate-900 border border-slate-600 text-white placeholder-slate-500 focus:ring-2 focus:ring-brand-500" placeholder="Add a tip or comment..."></textarea>
            <button type="submit" class="mt-2 px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white text-sm font-medium">Post comment</button>
        </form>
        <ul class="space-y-3 divide-y divide-slate-700/50">
            <?php if (empty($comments)): ?>
            <li class="text-slate-500 text-sm py-2">No comments yet.</li>
            <?php else: ?>
            <?php foreach ($comments as $c): ?>
            <li class="pt-3">
                <p class="text-slate-300"><?= nl2br(htmlspecialchars($c['body'])) ?></p>
                <p class="text-slate-500 text-xs mt-1"><?= htmlspecialchars($c['email']) ?> · <?= date('M j, Y', strtotime($c['created_at'])) ?></p>
            </li>
            <?php endforeach; ?>
            <?php endif; ?>
        </ul>
    </div>
</div>
