<div class="space-y-8">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <h1 class="text-2xl font-bold text-white">Dashboard</h1>
        <div class="flex flex-wrap gap-2">
            <a href="<?= $base ?>/reminders" class="inline-flex items-center px-4 py-2 rounded-xl bg-slate-700 hover:bg-slate-600 text-white text-sm font-medium transition">Reminders</a>
            <a href="<?= $base ?>/plans" class="inline-flex items-center px-4 py-2 rounded-xl bg-slate-700 hover:bg-slate-600 text-white text-sm font-medium transition">My Plans</a>
            <a href="<?= $base ?>/progress/log" class="inline-flex items-center px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white text-sm font-medium transition">Log Workout</a>
        </div>
    </div>

    <!-- Today's reminders + streak -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <div class="lg:col-span-2 bg-brand-500/10 border border-brand-500/30 rounded-2xl p-5">
            <h2 class="font-semibold text-brand-300 mb-2">Today's reminders</h2>
            <?php if (empty($todayReminders)): ?>
            <p class="text-slate-400 text-sm">No reminders for today. <a href="<?= $base ?>/reminders" class="text-brand-400 hover:underline">View all</a></p>
            <?php else: ?>
            <ul class="space-y-2">
                <?php foreach (array_slice($todayReminders, 0, 3) as $r): ?>
                <li class="flex items-center justify-between gap-2 text-sm">
                    <span class="text-white"><?= htmlspecialchars($r['title']) ?></span>
                    <a href="<?= $base ?>/plans/start?plan_id=<?= (int)($r['plan_id'] ?? 0) ?>&day=<?= (int)($r['day_number'] ?? 1) ?>" class="text-brand-400 hover:underline">Start →</a>
                </li>
                <?php endforeach; ?>
            </ul>
            <a href="<?= $base ?>/reminders" class="text-brand-400 text-sm mt-2 inline-block">View all reminders</a>
            <?php endif; ?>
        </div>
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6 card-hover text-center">
            <p class="text-slate-400 text-sm font-medium">Current streak</p>
            <p class="mt-1 text-3xl font-bold text-brand-400"><?= (int)($streak ?? 0) ?> <span class="text-lg font-normal text-slate-400">days</span></p>
        </div>
    </div>

    <!-- Stats -->
    <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6 card-hover">
            <p class="text-slate-400 text-sm font-medium">Total Workouts</p>
            <p class="mt-1 text-2xl font-bold text-white"><?= (int)($stats['total_workouts'] ?? 0) ?></p>
        </div>
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6 card-hover">
            <p class="text-slate-400 text-sm font-medium">Completed</p>
            <p class="mt-1 text-2xl font-bold text-brand-400"><?= (int)($stats['completed_workouts'] ?? 0) ?></p>
        </div>
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6 card-hover">
            <p class="text-slate-400 text-sm font-medium">Avg. Difficulty</p>
            <p class="mt-1 text-2xl font-bold text-white"><?= $stats['avg_difficulty'] ? number_format((float)$stats['avg_difficulty'], 1) : '—' ?></p>
        </div>
    </div>

    <!-- Next workout + Active plan -->
    <?php if ($activePlan && !empty($nextWorkoutDay)): ?>
    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6 flex flex-wrap items-center justify-between gap-4">
        <div>
            <h2 class="text-lg font-semibold text-white">Next workout</h2>
            <p class="text-slate-400 text-sm mt-0.5">Day <?= (int)$nextWorkoutDay ?> of your plan</p>
        </div>
        <a href="<?= $base ?>/plans/start?plan_id=<?= (int)$activePlan['id'] ?>&day=<?= (int)$nextWorkoutDay ?>" class="px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white text-sm font-medium transition">
            Start workout
        </a>
    </div>
    <?php endif; ?>

    <!-- Active plan -->
    <?php if ($activePlan): ?>
    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 overflow-hidden card-hover">
        <div class="p-6 border-b border-slate-700/50 flex flex-wrap items-center justify-between gap-4">
            <div>
                <h2 class="text-lg font-semibold text-white">Active Plan</h2>
                <p class="text-slate-400 text-sm mt-0.5">
                    Started <?= date('M j, Y', strtotime($activePlan['start_date'])) ?> · <?= (int)$activePlan['duration_weeks'] ?> weeks
                </p>
            </div>
            <a href="<?= $base ?>/plans?id=<?= (int)$activePlan['id'] ?>" class="px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white text-sm font-medium transition">
                View Plan
            </a>
        </div>
    </div>
    <?php else: ?>
    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-8 text-center">
        <p class="text-slate-400">You don't have an active plan yet.</p>
        <p class="text-slate-500 text-sm mt-1">Complete your profile, then generate a plan.</p>
        <a href="<?= $base ?>/profile/edit" class="inline-block mt-4 px-4 py-2 rounded-xl bg-slate-700 hover:bg-slate-600 text-white text-sm font-medium transition">Edit Profile</a>
        <span class="mx-2 text-slate-500">or</span>
        <form method="post" action="<?= $base ?>/plans/generate" class="inline">
            <button type="submit" class="px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white text-sm font-medium transition">Generate Plan</button>
        </form>
    </div>
    <?php endif; ?>

    <!-- Recent plans -->
    <?php if (!empty($plans)): ?>
    <div>
        <h2 class="text-lg font-semibold text-white mb-4">Your Plans</h2>
        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
            <?php foreach (array_slice($plans, 0, 6) as $p): ?>
            <a href="<?= $base ?>/plans?id=<?= (int)$p['id'] ?>" class="block bg-slate-800/60 rounded-xl border border-slate-700/50 p-4 card-hover">
                <span class="inline-block px-2 py-0.5 rounded text-xs font-medium
                    <?= $p['status'] === 'active' ? 'bg-brand-500/20 text-brand-400' : ($p['status'] === 'completed' ? 'bg-slate-500/20 text-slate-400' : 'bg-slate-600/20 text-slate-500') ?>">
                    <?= htmlspecialchars($p['status']) ?>
                </span>
                <p class="mt-2 font-medium text-white"><?= date('M j, Y', strtotime($p['generated_at'])) ?></p>
                <p class="text-slate-400 text-sm"><?= (int)$p['duration_weeks'] ?> weeks</p>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>
</div>
