<?php
$title = $title ?? 'Admin';
$base = $base ?? '';
?>
<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title) ?> | Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = { theme: { extend: { colors: { brand: { 500: '#22c55e', 600: '#16a34a' }, slate: { 800: '#1e293b', 900: '#0f172a' } } } } }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Inter', sans-serif; } </style>
</head>
<body class="bg-slate-100 text-slate-900 min-h-screen">
    <nav class="bg-slate-900 text-white shadow">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-14">
                <div class="flex items-center gap-6">
                    <a href="<?= $base ?>/admin" class="font-semibold text-brand-400">Admin</a>
                    <a href="<?= $base ?>/admin/exercises" class="text-slate-300 hover:text-white">Exercises</a>
                    <a href="<?= $base ?>/admin/users" class="text-slate-300 hover:text-white">Users</a>
                    <a href="<?= $base ?>/admin/comments" class="text-slate-300 hover:text-white">Comments</a>
                </div>
                <div class="flex items-center gap-4">
                    <span class="text-slate-400 text-sm"><?= htmlspecialchars($_user_email ?? '') ?></span>
                    <a href="<?= $base ?>/" class="text-slate-400 hover:text-white text-sm">View site</a>
                    <a href="<?= $base ?>/logout" class="text-red-400 hover:text-red-300 text-sm">Logout</a>
                </div>
            </div>
        </div>
    </nav>
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <?php if (!empty($_view_path) && is_file($_view_path)) include $_view_path; ?>
    </main>
</body>
</html>
