<?php
$ex = $exercise ?? null;
$isEdit = $ex !== null;
$muscles = $isEdit && !empty($ex['target_muscles']) ? (is_array($ex['target_muscles']) ? $ex['target_muscles'] : json_decode($ex['target_muscles'], true)) : [];
$equip = $isEdit && !empty($ex['equipment']) ? (is_array($ex['equipment']) ? $ex['equipment'] : json_decode($ex['equipment'], true)) : [];
$musclesStr = is_array($muscles) ? implode(', ', $muscles) : '';
$equipStr = is_array($equip) ? implode(', ', $equip) : '';
?>
<div class="max-w-2xl">
    <h1 class="text-2xl font-bold text-slate-900 mb-6"><?= $isEdit ? 'Edit' : 'Add' ?> Exercise</h1>
    <form method="post" action="<?= $base ?>/admin/exercises/save" class="bg-white rounded-xl shadow-sm border border-slate-200 p-6 space-y-4">
        <input type="hidden" name="id" value="<?= $isEdit ? (int)$ex['id'] : 0 ?>">
        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1">Name</label>
            <input type="text" name="name" required value="<?= $isEdit ? htmlspecialchars($ex['name']) : '' ?>"
                   class="w-full px-3 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-brand-500 focus:border-brand-500">
        </div>
        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1">Description</label>
            <textarea name="description" rows="3" class="w-full px-3 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-brand-500"><?= $isEdit ? htmlspecialchars($ex['description'] ?? '') : '' ?></textarea>
        </div>
        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1">Difficulty</label>
            <select name="difficulty" class="w-full px-3 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-brand-500">
                <option value="beginner" <?= ($isEdit && ($ex['difficulty'] ?? '') === 'beginner') ? 'selected' : '' ?>>Beginner</option>
                <option value="intermediate" <?= ($isEdit && ($ex['difficulty'] ?? '') === 'intermediate') ? 'selected' : '' ?>>Intermediate</option>
                <option value="advanced" <?= ($isEdit && ($ex['difficulty'] ?? '') === 'advanced') ? 'selected' : '' ?>>Advanced</option>
            </select>
        </div>
        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1">Target muscles (comma-separated)</label>
            <input type="text" name="target_muscles" value="<?= htmlspecialchars($musclesStr) ?>"
                   class="w-full px-3 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-brand-500" placeholder="chest, triceps">
        </div>
        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1">Equipment (comma-separated)</label>
            <input type="text" name="equipment" value="<?= htmlspecialchars($equipStr) ?>"
                   class="w-full px-3 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-brand-500" placeholder="dumbbell, barbell">
        </div>
        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1">Demonstration URL</label>
            <input type="url" name="demonstration_url" value="<?= $isEdit ? htmlspecialchars($ex['demonstration_url'] ?? '') : '' ?>"
                   class="w-full px-3 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-brand-500">
        </div>
        <div class="flex gap-3 pt-2">
            <button type="submit" class="px-4 py-2 bg-brand-600 text-white rounded-lg font-medium hover:bg-brand-500">Save</button>
            <a href="<?= $base ?>/admin/exercises" class="px-4 py-2 border border-slate-300 rounded-lg text-slate-700 hover:bg-slate-50">Cancel</a>
        </div>
    </form>
</div>
