<div class="mb-8">
    <h1 class="text-2xl font-bold text-slate-900">Admin Dashboard</h1>
    <p class="text-slate-600 mt-1">Overview of your workout platform</p>
</div>

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6">
        <p class="text-slate-500 text-sm font-medium">Total Users</p>
        <p class="text-2xl font-bold text-slate-900 mt-1"><?= (int)($totalUsers ?? 0) ?></p>
    </div>
    <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6">
        <p class="text-slate-500 text-sm font-medium">Workout Plans</p>
        <p class="text-2xl font-bold text-slate-900 mt-1"><?= (int)($totalPlans ?? 0) ?></p>
    </div>
    <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6">
        <p class="text-slate-500 text-sm font-medium">Exercises</p>
        <p class="text-2xl font-bold text-slate-900 mt-1"><?= (int)($totalExercises ?? 0) ?></p>
    </div>
    <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6">
        <p class="text-slate-500 text-sm font-medium">Comments</p>
        <p class="text-2xl font-bold text-slate-900 mt-1"><?= (int)($totalComments ?? 0) ?></p>
    </div>
</div>

<div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden">
    <div class="px-6 py-4 border-b border-slate-200">
        <h2 class="font-semibold text-slate-900">Recent Comments</h2>
    </div>
    <?php if (empty($recentComments)): ?>
    <div class="p-8 text-center text-slate-500">No comments yet.</div>
    <?php else: ?>
    <ul class="divide-y divide-slate-200">
        <?php foreach ($recentComments as $c): ?>
        <li class="px-6 py-4">
            <p class="text-slate-700"><?= nl2br(htmlspecialchars($c['body'])) ?></p>
            <p class="text-slate-500 text-sm mt-1"><?= htmlspecialchars($c['email']) ?> · <?= $c['target_type'] ?> #<?= (int)$c['target_id'] ?> · <?= date('M j, Y H:i', strtotime($c['created_at'])) ?></p>
        </li>
        <?php endforeach; ?>
    </ul>
    <?php endif; ?>
</div>
