<div class="mb-6">
    <h1 class="text-2xl font-bold text-slate-900">Comments</h1>
    <p class="text-slate-600 mt-1">User comments on exercises and progress logs</p>
</div>
<div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden">
    <ul class="divide-y divide-slate-200">
        <?php if (empty($comments)): ?>
        <li class="p-8 text-center text-slate-500">No comments yet.</li>
        <?php else: ?>
        <?php foreach ($comments as $c): ?>
        <li class="px-6 py-4">
            <p class="text-slate-800"><?= nl2br(htmlspecialchars($c['body'])) ?></p>
            <p class="text-slate-500 text-sm mt-2"><?= htmlspecialchars($c['email']) ?> · <?= htmlspecialchars($c['target_type']) ?> #<?= (int)$c['target_id'] ?> · <?= date('M j, Y H:i', strtotime($c['created_at'])) ?></p>
        </li>
        <?php endforeach; ?>
        <?php endif; ?>
    </ul>
</div>
