<?php

declare(strict_types=1);

try {
    require_once dirname(__DIR__) . '/includes/bootstrap.php';
} catch (Throwable $e) {
    http_response_code(500);
    header('Content-Type: text/html; charset=utf-8');
    echo '<h1>Bootstrap Error</h1><pre>' . htmlspecialchars($e->getMessage() . "\n\n" . $e->getTraceAsString()) . '</pre>';
    exit;
}

$requestUri = $_SERVER['REQUEST_URI'] ?? '/';
$scriptName = dirname($_SERVER['SCRIPT_NAME'] ?? '');
if ($scriptName !== '/' && $scriptName !== '' && strpos($requestUri, $scriptName) === 0) {
    $requestUri = substr($requestUri, strlen($scriptName)) ?: '/';
}
$path = parse_url($requestUri, PHP_URL_PATH) ?: '/';
$path = '/' . trim($path, '/');

$routes = [
    'GET' => [
        '/' => [Controllers\DashboardController::class, 'index'],
        '/login' => [Controllers\AuthController::class, 'showLogin'],
        '/register' => [Controllers\AuthController::class, 'showRegister'],
        '/logout' => [Controllers\AuthController::class, 'logout'],
        '/profile' => [Controllers\ProfileController::class, 'show'],
        '/profile/edit' => [Controllers\ProfileController::class, 'edit'],
        '/exercises' => [Controllers\ExerciseController::class, 'index'],
        '/exercises/show' => [Controllers\ExerciseController::class, 'show'],
        '/plans' => [Controllers\WorkoutPlanController::class, 'index'],
        '/plans/show' => [Controllers\WorkoutPlanController::class, 'show'],
        '/plans/start' => [Controllers\WorkoutPlanController::class, 'startWorkout'],
        '/plans/session' => [Controllers\WorkoutPlanController::class, 'session'],
        '/progress' => [Controllers\ProgressController::class, 'index'],
        '/progress/log' => [Controllers\ProgressController::class, 'showLogForm'],
        '/reminders' => [Controllers\ReminderController::class, 'index'],
        '/admin' => [Controllers\AdminController::class, 'dashboard'],
        '/admin/exercises' => [Controllers\AdminController::class, 'exercises'],
        '/admin/exercises/create' => [Controllers\AdminController::class, 'exerciseCreate'],
        '/admin/exercises/edit' => [Controllers\AdminController::class, 'exerciseEdit'],
        '/admin/users' => [Controllers\AdminController::class, 'users'],
        '/admin/comments' => [Controllers\AdminController::class, 'comments'],
    ],
    'POST' => [
        '/login' => [Controllers\AuthController::class, 'login'],
        '/register' => [Controllers\AuthController::class, 'register'],
        '/profile/update' => [Controllers\ProfileController::class, 'update'],
        '/plans/generate' => [Controllers\WorkoutPlanController::class, 'generate'],
        '/plans/status' => [Controllers\WorkoutPlanController::class, 'setStatus'],
        '/plans/session/complete' => [Controllers\WorkoutPlanController::class, 'completeSession'],
        '/plans/session/set' => [Controllers\WorkoutPlanController::class, 'logSet'],
        '/progress/log' => [Controllers\ProgressController::class, 'log'],
        '/reminders/dismiss' => [Controllers\ReminderController::class, 'dismiss'],
        '/comments' => [Controllers\CommentController::class, 'add'],
        '/admin/exercises/save' => [Controllers\AdminController::class, 'exerciseSave'],
        '/admin/exercises/delete' => [Controllers\AdminController::class, 'exerciseDelete'],
    ],
];

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';

if ($path === '/plans' && isset($_GET['id'])) {
    $path = '/plans/show';
}

// Debug page (open http://127.0.0.1/nessa/public/debug) – remove this block after fixing errors
if ($method === 'GET' && ($path === '/debug' || $path === '/debug.php')) {
    header('Content-Type: text/html; charset=utf-8');
    echo '<h1>Debug</h1><p>PHP: ' . PHP_VERSION . '</p>';
    echo '<p>DOCUMENT_ROOT: ' . htmlspecialchars($_SERVER['DOCUMENT_ROOT'] ?? '') . '</p>';
    echo '<p>SCRIPT_NAME: ' . htmlspecialchars($_SERVER['SCRIPT_NAME'] ?? '') . '</p>';
    echo '<p>REQUEST_URI: ' . htmlspecialchars($_SERVER['REQUEST_URI'] ?? '') . '</p>';
    echo '<p>Resolved path: ' . htmlspecialchars($path) . '</p>';
    $base = dirname(__DIR__);
    echo '<p>Project base: ' . htmlspecialchars($base) . '</p>';
    echo '<p>config/Database.php exists: ' . (is_file($base . '/config/Database.php') ? 'yes' : 'no') . '</p>';
    echo '<h2>Bootstrap + login</h2>';
    try {
        require_once $base . '/includes/autoload.php';
        [$class, $action] = [Controllers\AuthController::class, 'showLogin'];
        ob_start();
        (new $class())->$action();
        $out = ob_get_clean();
        echo '<p>Login page OK, ' . strlen($out) . ' bytes.</p>';
    } catch (Throwable $e) {
        echo '<p style="color:red">' . htmlspecialchars($e->getMessage()) . '</p><pre>' . htmlspecialchars($e->getTraceAsString()) . '</pre>';
    }
    exit;
}

$handler = $routes[$method][$path] ?? null;

if ($handler) {
    try {
        [$class, $action] = $handler;
        (new $class())->$action();
        exit;
    } catch (Throwable $e) {
        http_response_code(500);
        header('Content-Type: text/html; charset=utf-8');
        echo '<h1>Application Error</h1><pre>' . htmlspecialchars($e->getMessage() . "\n\n" . $e->getTraceAsString()) . '</pre>';
        exit;
    }
}

http_response_code(404);
echo '<!DOCTYPE html><html><head><title>404</title></head><body><h1>Not Found</h1><p><a href="/">Go home</a></p></body></html>';
