<?php

declare(strict_types=1);

namespace Models;

class WorkoutSetLog extends Model
{
    protected string $table = 'workout_set_logs';

    public function getBySessionId(int $sessionId): array
    {
        $stmt = $this->db->prepare("
            SELECT sl.*, pe.exercise_id, pe.sets, pe.reps, e.name AS exercise_name
            FROM {$this->table} sl
            JOIN plan_exercises pe ON pe.id = sl.plan_exercise_id
            JOIN exercises e ON e.id = pe.exercise_id
            WHERE sl.session_id = ?
            ORDER BY pe.day_number, pe.id, sl.set_number
        ");
        $stmt->execute([$sessionId]);
        return $stmt->fetchAll();
    }

    public function upsertForSession(int $sessionId, int $planExerciseId, int $setNumber, ?int $repsCompleted = null, ?float $weightUsed = null, bool $completed = true, ?string $notes = null): int
    {
        $stmt = $this->db->prepare("
            SELECT id FROM {$this->table} WHERE session_id = ? AND plan_exercise_id = ? AND set_number = ?
        ");
        $stmt->execute([$sessionId, $planExerciseId, $setNumber]);
        $row = $stmt->fetch();
        $data = [
            'reps_completed' => $repsCompleted,
            'weight_used' => $weightUsed,
            'completed' => $completed ? 1 : 0,
            'notes' => $notes,
        ];
        if ($row) {
            $this->update((int) $row['id'], $data);
            return (int) $row['id'];
        }
        return $this->insert(array_merge([
            'session_id' => $sessionId,
            'plan_exercise_id' => $planExerciseId,
            'set_number' => $setNumber,
        ], $data));
    }

    public function getBySessionAndPlanExercise(int $sessionId, int $planExerciseId): array
    {
        $stmt = $this->db->prepare("
            SELECT * FROM {$this->table} WHERE session_id = ? AND plan_exercise_id = ?
            ORDER BY set_number
        ");
        $stmt->execute([$sessionId, $planExerciseId]);
        return $stmt->fetchAll();
    }
}
