<?php

declare(strict_types=1);

namespace Models;

/**
 * Creates and manages reminders (e.g. auto-remind on workout days).
 */
class ReminderService
{
    private Reminder $reminderModel;

    public function __construct()
    {
        $this->reminderModel = new Reminder();
    }

    public function createRemindersForPlan(int $userId, int $planId, string $startDate, int $durationWeeks, array $dayNumbers): void
    {
        $start = new \DateTime($startDate);
        $end = (clone $start)->modify("+{$durationWeeks} weeks");
        foreach ($dayNumbers as $dayNum) {
            $date = clone $start;
            $daysToAdd = $dayNum - 1;
            if ($daysToAdd > 0) {
                $date->modify("+{$daysToAdd} days");
            }
            while ($date <= $end) {
                $remindAt = $date->format('Y-m-d') . ' 09:00:00';
                $this->reminderModel->create(
                    $userId,
                    $remindAt,
                    'workout',
                    "Workout Day {$dayNum}",
                    "Time for your Day {$dayNum} workout!",
                    $planId,
                    $dayNum
                );
                $date->modify('+7 days');
            }
        }
    }

    public function getTodayReminders(int $userId): array
    {
        return $this->reminderModel->getTodayForUser($userId);
    }
}
