<?php

declare(strict_types=1);

namespace Models;

class Reminder extends Model
{
    protected string $table = 'reminders';

    public function getUpcomingForUser(int $userId, int $limit = 20): array
    {
        $stmt = $this->db->prepare("
            SELECT r.*, wp.duration_weeks
            FROM {$this->table} r
            LEFT JOIN workout_plans wp ON wp.id = r.plan_id
            WHERE r.user_id = ? AND r.dismissed = 0 AND r.remind_at >= NOW()
            ORDER BY r.remind_at ASC
            LIMIT ?
        ");
        $stmt->execute([$userId, $limit]);
        return $stmt->fetchAll();
    }

    public function getTodayForUser(int $userId): array
    {
        $stmt = $this->db->prepare("
            SELECT r.* FROM {$this->table} r
            WHERE r.user_id = ? AND r.dismissed = 0
            AND DATE(r.remind_at) = CURDATE()
            ORDER BY r.remind_at ASC
        ");
        $stmt->execute([$userId]);
        return $stmt->fetchAll();
    }

    public function create(int $userId, string $remindAt, string $type, string $title, ?string $message = null, ?int $planId = null, ?int $dayNumber = null): int
    {
        return $this->insert([
            'user_id' => $userId,
            'remind_at' => $remindAt,
            'type' => $type,
            'title' => $title,
            'message' => $message,
            'plan_id' => $planId,
            'day_number' => $dayNumber,
        ]);
    }

    public function dismiss(int $id, int $userId): bool
    {
        $stmt = $this->db->prepare("UPDATE {$this->table} SET dismissed = 1 WHERE id = ? AND user_id = ?");
        return $stmt->execute([$id, $userId]);
    }

    public function getByUserId(int $userId, bool $includeDismissed = false): array
    {
        $sql = "SELECT * FROM {$this->table} WHERE user_id = ?";
        if (!$includeDismissed) {
            $sql .= " AND dismissed = 0";
        }
        $sql .= " ORDER BY remind_at DESC";
        $stmt = $this->db->prepare($sql);
        $stmt->execute([$userId]);
        return $stmt->fetchAll();
    }
}
