<?php

declare(strict_types=1);

namespace Models;

class PlanExercise extends Model
{
    protected string $table = 'plan_exercises';

    public function getByPlanId(int $planId): array
    {
        $stmt = $this->db->prepare("
            SELECT pe.*, e.name AS exercise_name, e.description, e.target_muscles, e.equipment, e.difficulty, e.demonstration_url
            FROM {$this->table} pe
            JOIN exercises e ON e.id = pe.exercise_id
            WHERE pe.plan_id = ?
            ORDER BY pe.day_number, pe.id
        ");
        $stmt->execute([$planId]);
        $rows = $stmt->fetchAll();
        foreach ($rows as &$row) {
            if (!empty($row['target_muscles'])) $row['target_muscles'] = json_decode($row['target_muscles'], true);
            if (!empty($row['equipment'])) $row['equipment'] = json_decode($row['equipment'], true);
        }
        return $rows;
    }

    public function getByPlanIdGroupedByDay(int $planId): array
    {
        $all = $this->getByPlanId($planId);
        $grouped = [];
        foreach ($all as $row) {
            $day = (int) $row['day_number'];
            if (!isset($grouped[$day])) $grouped[$day] = [];
            $grouped[$day][] = $row;
        }
        ksort($grouped);
        return $grouped;
    }

    public function addToPlan(int $planId, int $exerciseId, int $dayNumber, int $sets = 3, string $reps = '10', ?string $intensity = null, int $restSeconds = 60): int
    {
        return $this->insert([
            'plan_id' => $planId,
            'exercise_id' => $exerciseId,
            'day_number' => $dayNumber,
            'sets' => $sets,
            'reps' => $reps,
            'intensity' => $intensity,
            'rest_seconds' => $restSeconds,
        ]);
    }

    public function clearPlan(int $planId): void
    {
        $stmt = $this->db->prepare("DELETE FROM {$this->table} WHERE plan_id = ?");
        $stmt->execute([$planId]);
    }
}
