<?php

declare(strict_types=1);

namespace Models;

class Exercise extends Model
{
    protected string $table = 'exercises';

    public function allWithDecoded(): array
    {
        $rows = $this->all('name');
        foreach ($rows as &$row) {
            if (!empty($row['target_muscles'])) $row['target_muscles'] = json_decode($row['target_muscles'], true);
            if (!empty($row['equipment'])) $row['equipment'] = json_decode($row['equipment'], true);
        }
        return $rows;
    }

    public function findByDifficulty(string $difficulty): array
    {
        $stmt = $this->db->prepare("SELECT * FROM {$this->table} WHERE difficulty = ? ORDER BY name");
        $stmt->execute([$difficulty]);
        return $stmt->fetchAll();
    }

    public function getByIds(array $ids): array
    {
        if (empty($ids)) return [];
        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        $stmt = $this->db->prepare("SELECT * FROM {$this->table} WHERE id IN ({$placeholders})");
        $stmt->execute($ids);
        return $stmt->fetchAll();
    }

    public function createRecord(array $data): int
    {
        return $this->insert($data);
    }

    public function updateRecord(int $id, array $data): bool
    {
        return $this->update($id, $data);
    }
}
