<?php

declare(strict_types=1);

namespace Controllers;

use Models\Profile;

class ProfileController extends BaseController
{
    public function edit(): void
    {
        $userId = $this->requireAuth();
        $profileModel = new Profile();
        $profile = $profileModel->getByUserId($userId);

        $this->view('profile/edit', [
            'title' => 'My Profile',
            'profile' => $profile,
        ]);
    }

    public function update(): void
    {
        $userId = $this->requireAuth();
        $profileModel = new Profile();

        $goals = $_POST['goals'] ?? [];
        if (is_string($goals)) {
            $goals = array_filter(array_map('trim', explode(',', $goals)));
        }
        $preferences = $_POST['preferences'] ?? [];
        if (is_string($preferences)) {
            $preferences = array_filter(array_map('trim', explode(',', $preferences)));
        }

        $profileModel->createOrUpdate($userId, [
            'age' => $_POST['age'] ?? null,
            'gender' => $_POST['gender'] ?? null,
            'fitness_level' => isset($_POST['fitness_level']) ? (int) $_POST['fitness_level'] : null,
            'health_conditions' => $_POST['health_conditions'] ?? null,
            'goals' => $goals,
            'preferences' => $preferences,
            'weekly_time_available' => isset($_POST['weekly_time_available']) ? (int) $_POST['weekly_time_available'] : null,
        ]);

        $this->redirect('/profile?updated=1');
    }

    public function show(): void
    {
        $userId = $this->requireAuth();
        $profileModel = new Profile();
        $profile = $profileModel->getByUserId($userId);

        $this->view('profile/show', [
            'title' => 'My Profile',
            'profile' => $profile,
        ]);
    }
}
