<?php

declare(strict_types=1);

namespace Controllers;

use Models\WorkoutPlan;
use Models\ProgressLog;
use Models\Profile;
use Models\Reminder;
use Models\WorkoutSession;

class DashboardController extends BaseController
{
    public function index(): void
    {
        $userId = $this->requireAuth();
        $planModel = new WorkoutPlan();
        $logModel = new ProgressLog();
        $profileModel = new Profile();
        $reminderModel = new Reminder();
        $sessionModel = new WorkoutSession();

        $activePlan = $planModel->getActiveByUserId($userId);
        $plans = $planModel->getByUserId($userId);
        $stats = $logModel->getStatsForUser($userId);
        $profile = $profileModel->getByUserId($userId);
        try {
            $todayReminders = $reminderModel->getTodayForUser($userId);
        } catch (\Throwable $e) {
            $todayReminders = [];
        }
        try {
            $streak = $logModel->getStreak($userId);
        } catch (\Throwable $e) {
            $streak = 0;
        }
        $nextWorkoutDay = null;
        if ($activePlan) {
            try {
                $lastSession = $sessionModel->getForUserAndPlan($userId, (int)$activePlan['id']);
                $lastDay = 0;
                foreach ($lastSession as $s) {
                    if (!empty($s['completed_at']) && (int)$s['day_number'] > $lastDay) {
                        $lastDay = (int)$s['day_number'];
                    }
                }
                $planExerciseModel = new \Models\PlanExercise();
                $byDay = $planExerciseModel->getByPlanIdGroupedByDay((int)$activePlan['id']);
                $maxDay = !empty($byDay) ? max(array_keys($byDay)) : 0;
                $nextWorkoutDay = $lastDay < $maxDay ? $lastDay + 1 : 1;
            } catch (\Throwable $e) {
                $nextWorkoutDay = 1;
            }
        }

        $this->view('dashboard/index', [
            'title' => 'Dashboard',
            'activePlan' => $activePlan,
            'plans' => $plans,
            'stats' => $stats,
            'profile' => $profile,
            'todayReminders' => $todayReminders,
            'streak' => $streak,
            'nextWorkoutDay' => $nextWorkoutDay,
        ]);
    }
}
