<?php

declare(strict_types=1);

namespace Controllers;

use Models\Comment;

class CommentController extends BaseController
{
    public function add(): void
    {
        $userId = $this->requireAuth();
        $targetType = $_POST['target_type'] ?? '';
        $targetId = (int) ($_POST['target_id'] ?? 0);
        $body = trim($_POST['body'] ?? '');
        if (!in_array($targetType, ['exercise', 'progress_log'], true) || $targetId <= 0 || $body === '') {
            $this->redirect($_POST['redirect'] ?? '/');
            return;
        }
        $commentModel = new Comment();
        $commentModel->add($userId, $targetType, $targetId, $body);
        $this->redirect($_POST['redirect'] ?? '/');
    }
}
